<?php
require_once("db.php");
header("Content-Type: application/json; charset=utf-8");

function json_response($arr, $status=200) {
    http_response_code($status);
    echo json_encode($arr, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    exit;
}

function generate_token() {
    return hash("sha256", uniqid("", true) . random_int(100000, 999999));
}

function get_input() {
    $raw = file_get_contents("php://input");
    $in = json_decode($raw, true);
    return is_array($in) ? $in : [];
}

$in = get_input();
$route = $_GET["route"] ?? "";

try { $db = get_db(); } 
catch (Exception $e) { json_response(["error"=>"Error al conectar DB","detail"=>$e->getMessage()],500); }

if ($route === "auth/login") {
    $email = trim($in["email"] ?? "");
    $password = trim($in["password"] ?? "");
    $machine_id = trim($in["machine_id"] ?? "");
    if (!$email || !$password) json_response(["error"=>"Datos incompletos"],400);

    $st = $db->prepare("SELECT * FROM licencias WHERE email=? LIMIT 1");
    $st->execute([$email]);
    $user = $st->fetch(PDO::FETCH_ASSOC);
    if (!$user) json_response(["error"=>"Credenciales inválidas"],403);
    if (hash("sha256",$password)!==$user["password_hash"]) json_response(["error"=>"Credenciales inválidas"],403);

    $allowed = intval($user["allowed_devices"] ?? 2);
    $now = time();
    $expires = $now + 60*60*24*30;
    $token = generate_token();

    // Obtener dispositivos activos
    $st = $db->prepare("SELECT * FROM devices WHERE email=? ORDER BY last_seen ASC");
    $st->execute([$email]);
    $devices = $st->fetchAll(PDO::FETCH_ASSOC);
    $active = 0;
    foreach ($devices as $d) if ($d["expires_at"]>$now) $active++;

    // ¿Ya existe este equipo?
    $st = $db->prepare("SELECT id FROM devices WHERE email=? AND machine_id=?");
    $st->execute([$email,$machine_id]);
    $existing = $st->fetchColumn();

    $note = "";
    if ($existing) {
        $db->prepare("UPDATE devices SET token=?,expires_at=?,last_seen=? WHERE id=?")
           ->execute([$token,$expires,$now,$existing]);
        $note = "Dispositivo actualizado.";
    } else {
        if ($active >= $allowed) {
            $oldest = $devices[0]["id"];
            $db->prepare("DELETE FROM devices WHERE id=?")->execute([$oldest]);
            $note = "La sesión más antigua fue cerrada automáticamente.";
        } else {
            $note = "Nuevo dispositivo registrado.";
        }
        $db->prepare("INSERT INTO devices (email,machine_id,token,expires_at,last_seen) VALUES (?,?,?,?,?)")
           ->execute([$email,$machine_id,$token,$expires,$now]);
    }

    json_response([
        "token"=>$token,
        "expires_at"=>$expires,
        "plan"=>$user["plan"],
        "note"=>$note
    ]);
}

elseif ($route === "license/verify") {
    $auth = $_SERVER["HTTP_AUTHORIZATION"] ?? "";
    if (!preg_match("/Bearer\s+(\S+)/",$auth,$m)) json_response(["error"=>"Token faltante"],401);
    $token = $m[1];
    $machine_id = trim($in["machine_id"] ?? "");
    $now = time();

    $st = $db->prepare("SELECT * FROM devices WHERE token=?");
    $st->execute([$token]);
    $dev = $st->fetch(PDO::FETCH_ASSOC);
    if (!$dev) json_response(["valid"=>false,"error"=>"Token no encontrado"],403);

    if ($dev["expires_at"]<$now) {
        $db->prepare("DELETE FROM devices WHERE id=?")->execute([$dev["id"]]);
        json_response(["valid"=>false,"error"=>"Licencia expirada"],403);
    }

    $db->prepare("UPDATE devices SET last_seen=? WHERE id=?")->execute([$now,$dev["id"]]);
    json_response(["valid"=>true,"email"=>$dev["email"],"expires_at"=>$dev["expires_at"]]);
}

else {
    json_response(["error"=>"Ruta no encontrada"],404);
}
?>